/* ============ */
/* tstmnsd.c	*/
/* ============ */
#include <defcodes.h>
#include <math.h>
#include <miscdefs.h>
#include <gapdefs.h>
#include <mconf.h>
/* ==================================================================== */
/*		   Main Progrram to Test CalcGapMeanStdDev		*/
/* ==================================================================== */

#define	ACT(X)	#X

#define	NEED_NUMBER_GAPS(LO, HI) \
	"Enter Number of Gaps at Issue ["\
		ACT(LO)"-"ACT(HI)"]: "
#define	NEED_LO_GAP_LIM(LO, HI) \
	"Enter Lower Limit of Gap at Issue ["\
		">= "ACT(LO)", < "ACT(HI)"]: "

#define	MAX_GAPS	32767
#define	MIN_GAPS	  2
#include <miscdefs.h>
void
main()
{
    AbortGracefully();
    while (main)
    {
	int	NumGaps;
	double	HiLimit, LoLimit, Mean, StdDev;

	for (;;)
	{
	    GetInt(NEED_NUMBER_GAPS(MIN_GAPS, MAX_GAPS), &NumGaps);

	    if (NumGaps >= MIN_GAPS && NumGaps <= MAX_GAPS)
	    {
		break;
	    }
	    fprintf(stderr, "Incorrect Entry\n");
	}
	for (;;)
	{
	    GetDbl(NEED_LO_GAP_LIM(0,1), &LoLimit);

	    if (LoLimit >= 0 && LoLimit < 1)
	    {
		break;
	    }
	    fprintf(stderr, "Incorrect Entry\n");
	}

	for (;;)
	{
	    char    Prompt[64];
	    sprintf(Prompt, "Enter Upper Limit of Gap at Issue "
			    "[> %g, <= 1]: ", LoLimit);

	    GetDbl(Prompt, &HiLimit);

	    if (HiLimit > LoLimit && HiLimit <= 1)
	    {
		break;
	    }
	    fprintf(stderr, "Incorrect Entry\n");
	}
	CalcGapMeanStdDev(NumGaps, HiLimit-LoLimit, &Mean, &StdDev);

	fprintf(stderr, "Number of Random Numbers That Must be examined:\n");
	fprintf(stderr, "Number of Gaps = %d\nProbability = %g\n"
			"Mean = %g Variates, StdDev = %g Variates\n",
	    NumGaps, HiLimit-LoLimit, ceil(Mean), ceil(StdDev));
    }
}
